#include <bits/stdc++.h>
#include <unordered_map>

using namespace std;

const int MAX_N = 500100;

int N;
int X[MAX_N];
int heightArray[MAX_N];

// Tree
struct Node{
    int index;
    bool landable;
    int height;
    struct Node* parent;
    vector<Node *> kids;
};

// New node
Node *newNode(int index, Node* parent)
{
    Node *temp = new Node;
    temp->index = index;
    temp->landable = false;
    temp->height = -1;
    temp->parent = parent;
    return temp;
}

// Mapa koja cuva pokazivace na node-ove
unordered_map<int, Node*> nodePointers;

// Funkcija koja pravi niz koj sadrzi nodeove sortirane po visini
void make_heightArray()
{
    queue<Node *> q;
    q.push(nodePointers[1]);
    int i=0;
    while (!q.empty())
    {
        int n = q.size();

        while (n > 0)
        {
            Node * p = q.front();
            q.pop();
            heightArray[i]=p->index;
            p->height = i+1;
            i++;

            // Enqueue all children of the dequeued item
            for (int j=0; j<p->kids.size(); j++)
            {
                q.push(p->kids[j]);
            }
            n--;
        }
    }
}


// Pravimo stablo koje ima samo polja za sletanje
void make_landableTree()
{

}


int main()
{
    // Ulaz
    cin>>N;
    int U,V;
    for(int i=0;i<N-1;i++)
    {
        cin>>U>>V;
        Node *temp = new Node;

        // Ako samo U nije dodat
        if(nodePointers.find(U) == nodePointers.end())
        {
            nodePointers[U] = newNode(U, NULL);
        }

        // Ako samo V nije dodat
        if(nodePointers.find(V) == nodePointers.end())
        {
            nodePointers[V] = newNode(V, NULL);
        }

        // Povezivanje
        (nodePointers.at(U)->kids).push_back(nodePointers.at(V));
        nodePointers.at(V)->parent = nodePointers.at(U);
    }

    int b;
    for(int i=1;i<=N;i++)
    {
        cin>>b;
        if(b == 1)
        {
            nodePointers.at(i)->landable = true;
        }
    }

    for(int i=0;i<N;i++)
    {
        cin>>X[i];
    }

    // Racunamo visunu svakog polja
    make_heightArray();

    // Pravimo stablo koje ima samo polja na koja se moze skociti
    make_landableTree();

    // Obrada i ispis
    for(int i=1;i<=N;i++)
    {
        if(X[i-1] != 0)
        {
            nodePointers.at(X[i-1])->landable = ! nodePointers.at(X[i-1])->landable;
        }

        int rez = 0;

        int currentHeight = nodePointers.at(i)->height;
        while(currentHeight > 0)
        {
            // Iskocili smo iz stabla
            if(currentHeight - i <= 0)
            {
                rez++;
                break;
            }

            int startHeight = currentHeight;
            currentHeight = currentHeight - i;
            while(nodePointers.at(heightArray[currentHeight-1])->landable == false)
            {
                if(currentHeight+1 == startHeight)
                {
                    rez = -1;
                    break;
                }

                currentHeight++;
            }

            if(rez == -1)
            {
                break;
            }

            rez++;
        }
        cout<<rez<<" ";
    }

    return 0;
}